/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api.provider;

import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public interface PreviewProvider {
    @Deprecated(forRemoval=true, since="3.2.0")
    @ApiStatus.ScheduledForRemoval(inVersion="4.0.0")
    public static final float[] DEFAULT_COLOR = new float[]{1.0f, 1.0f, 1.0f};

    public boolean shouldDisplay(PreviewContext var1);

    public List<ItemStack> getInventory(PreviewContext var1);

    public int getInventoryMaxSize(PreviewContext var1);

    default public int getMaxRowSize(PreviewContext context) {
        return 0;
    }

    default public boolean isFullPreviewAvailable(PreviewContext context) {
        return true;
    }

    default public boolean showTooltipHints(PreviewContext context) {
        return true;
    }

    default public String getTooltipHintLangKey(PreviewContext context) {
        return "shulkerboxtooltip.hint.compact";
    }

    default public String getFullTooltipHintLangKey(PreviewContext context) {
        return "shulkerboxtooltip.hint.full";
    }

    @Deprecated(forRemoval=true, since="3.2.0")
    @ApiStatus.ScheduledForRemoval(inVersion="4.0.0")
    default public float[] getWindowColor(PreviewContext context) {
        return DEFAULT_COLOR;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public ColorKey getWindowColorKey(PreviewContext context) {
        float[] legacyColor = this.getWindowColor(context);
        return legacyColor == DEFAULT_COLOR ? ColorKey.DEFAULT : ColorKey.ofRgb(this.getWindowColor(context));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public PreviewRenderer getRenderer() {
        return PreviewRenderer.getDefaultRendererInstance();
    }

    default public List<Component> addTooltip(PreviewContext context) {
        return Collections.emptyList();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void onInventoryAccessStart(PreviewContext context) {
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    default public ResourceLocation getTextureOverride(PreviewContext context) {
        return null;
    }

    default public int getPriority() {
        return 1000;
    }
}

